/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************
 
   Filename:
    $Workfile: Sdo_Packets.h $
   Last Modification:
    $Author: Sven $
    $Modtime: 25.10.05 10:08 $
    $Revision: 10 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    Ecat Sdo
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      4        22.02.2011  EO
        Usage of TLR_PACKET_HEADER define removed against explicit definition of packet header.
        See issue #0012621: SdoPacket_Public.h: Header uses TLR_PACKET_HEADER define
        Define SDO_UPLOAD_EXP_DATA_CNF_SIZE removed.
        See issue #0012622: SdoPacket_Public.h: Wrong define for SDO_UPLOAD_EXP_DATA_CNF_SIZE

      3        17.02.2011  UJ
        important: new definitions SDO_DOWNLOAD_EXP_R2_REQ/CNF_T and SDO_UPLOAD_EXP_R2_REQ/CNF_T substitutes the old definitions
        SDO_DOWNLOAD_EXP_REQ/CNF_T and SDO_UPLOAD_EXP_REQ/CNF_T.
        The new structures have the standard elements (tHead, tData) and uses correct data field length values. Because they are backward
        compatible to the old depreciated structures, a user must not change anything in the code. For new development the *R2* definitions
        shall be used.

      2        17.08.2005  SB       1.000
        SDO download/upload packets for pointerless access

      1        30.06.2005  SB       1.000
        Created

**************************************************************************************/
#ifndef __SDO_PACKETS_H
#define __SDO_PACKETS_H

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(SDO_PUBLIC)
#endif

#define SDO_DEFAULT_ACCESS (0L) /* default access to subobject */

typedef struct SDO_DOWNLOAD_REQ_Ttag SDO_DOWNLOAD_REQ_T;
typedef struct SDO_DOWNLOAD_REQ_Ttag SDO_DOWNLOAD_CNF_T;

__TLR_PACKED_PRE struct SDO_DOWNLOAD_REQ_Ttag
{
  /* destination of the packet (task message queue reference) */
  TLR_UINT32  ulDest;
  /* source of the packet (task message queue reference) */
  TLR_UINT32  ulSrc;
  /* destination reference (internal use for message routing) */
  TLR_UINT32  ulDestId;
  /* source reference (internal use for message routing) */
  TLR_UINT32  ulSrcId;
  /* length of packet data (starting from the end of the header) */
  TLR_UINT32  ulLen;
  /* identification reference (internal use by the sender) */
  TLR_UINT32  ulId;
  /* operation status code (error code, initialize with 0) */
  TLR_UINT32  ulSta;
  /* operation command code */
  TLR_UINT32  ulCmd;
  /* extension count (nonzero in multi-packet transfers) */
  TLR_UINT32  ulExt;
  /* router reference (internal use for message routing) */
  TLR_UINT32  ulRout;

  /* packet list : SDO stack internal */
  SDO_DOWNLOAD_REQ_T*     ptNext;
  /* address of SDO server : parameter to be set */
  TLR_UINT32              ulServerAddress;
  /* index of SDO : parameter to be set  */
  TLR_UINT32              ulIndex;
  /* subindex of SDO : parameter to be set  */
  TLR_UINT32              ulSubIndex;
  /* access flags for SDO like priority, complete access etc */
  TLR_UINT32              ulAccessFlags;
  /* pointer to data of SDO : parameter to be set  */
  TLR_VOID*               ptSDOData;
  /* length of SDO : parameter to be set  */
  TLR_UINT32              ulSDOLength;
  /* transferred size of SDO : SDO stack internal */
  TLR_UINT32              ulTransferredSize;
  /* timeout value : SDO stack internal */
  TLR_UINT32              ulTimeout;
} __TLR_PACKED_POST;

#define SDO_DOWNLOAD_DATA_REQ_SIZE (sizeof(SDO_DOWNLOAD_REQ_T)-sizeof(TLR_PACKET_HEADER_T))
#define SDO_DOWNLOAD_DATA_CNF_SIZE (sizeof(SDO_DOWNLOAD_CNF_T)-sizeof(TLR_PACKET_HEADER_T))

typedef struct SDO_UPLOAD_REQ_Ttag SDO_UPLOAD_REQ_T;
typedef struct SDO_UPLOAD_REQ_Ttag SDO_UPLOAD_CNF_T;

__TLR_PACKED_PRE struct SDO_UPLOAD_REQ_Ttag
{
  /* destination of the packet (task message queue reference) */
  TLR_UINT32  ulDest;
  /* source of the packet (task message queue reference) */
  TLR_UINT32  ulSrc;
  /* destination reference (internal use for message routing) */
  TLR_UINT32  ulDestId;
  /* source reference (internal use for message routing) */
  TLR_UINT32  ulSrcId;
  /* length of packet data (starting from the end of the header) */
  TLR_UINT32  ulLen;
  /* identification reference (internal use by the sender) */
  TLR_UINT32  ulId;
  /* operation status code (error code, initialize with 0) */
  TLR_UINT32  ulSta;
  /* operation command code */
  TLR_UINT32  ulCmd;
  /* extension count (nonzero in multi-packet transfers) */
  TLR_UINT32  ulExt;
  /* router reference (internal use for message routing) */
  TLR_UINT32  ulRout;

  /* packet list : SDO stack internal */
  SDO_UPLOAD_REQ_T*       ptNext;
  /* address of SDO server : parameter to be set  */
  TLR_UINT32              ulServerAddress;
  /* index of SDO : parameter to be set  */
  TLR_UINT32              ulIndex;
  /* subindex of SDO : parameter to be set  */
  TLR_UINT32              ulSubIndex;
  /* access flags for SDO like priority, complete access etc : parameter to be set  */
  TLR_UINT32              ulAccessFlags;
  /* pointer to pointer to data of SDO : parameter to be set or NULL for allocation by SDO client stack */
  TLR_VOID**              pptSDOData;
  /* length of SDO : parameter to be set  */
  TLR_UINT32              ulSDOLength;
  /* if buffer is prepared set this field to length of buffer, otherwise 0 */
  TLR_UINT32              ulMaxSDOLength;
  /* transferred size of SDO : SDO stack internal */
  TLR_UINT32              ulTransferredSize;
  /* timeout value : SDO stack internal */
  TLR_UINT32              ulTimeout;
} __TLR_PACKED_POST;

#define SDO_UPLOAD_DATA_REQ_SIZE (sizeof(SDO_UPLOAD_REQ_T)-sizeof(TLR_PACKET_HEADER_T))
#define SDO_UPLOAD_DATA_CNF_SIZE (sizeof(SDO_UPLOAD_CNF_T)-sizeof(TLR_PACKET_HEADER_T))


/***********************************/
/* New "Rev2" packet definitions.  */
/***********************************/

#define SDO_DOWNLOAD_EXP_DATA_SIZE_R2 (1536)

/* 2 commands uses this packet definition: ECAT_LOCAL_SDO_DOWNLOAD_EXP_REQ and ECAT_SDO_DOWNLOAD_EXP_REQ */
__TLR_PACKED_PRE struct SDO_DOWNLOAD_EXP_R2_REQ_DATA_Ttag
{
  /* address of SDO server, set to 0 for ECAT_LOCAL_SDO_DOWNLOAD_EXP_REQ service */
  TLR_UINT32              ulServerAddress;
  /* index of SDO */
  TLR_UINT32              ulIndex;
  /* subindex of SDO */
  TLR_UINT32              ulSubIndex;
  /* access flags (complete access, evt. priority) */
  TLR_UINT32              ulAccessFlags;
  /* length of SDO */
  TLR_UINT32              ulSDOLength;
  /* data of SDO download */
  TLR_UINT8               abData[SDO_DOWNLOAD_EXP_DATA_SIZE_R2];
} __TLR_PACKED_POST;

typedef struct SDO_DOWNLOAD_EXP_R2_REQ_DATA_Ttag SDO_DOWNLOAD_EXP_R2_REQ_DATA_T;


struct SDO_DOWNLOAD_EXP_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T            tHead;
  SDO_DOWNLOAD_EXP_R2_REQ_DATA_T tData;
};

typedef struct SDO_DOWNLOAD_EXP_R2_REQ_Ttag SDO_DOWNLOAD_EXP_R2_REQ_T;


struct SDO_DOWNLOAD_EXP_R2_CNF_Ttag
{
  TLR_PACKET_HEADER_T            tHead;
  /* the confirmation packet has no data part */
};

typedef struct SDO_DOWNLOAD_EXP_R2_CNF_Ttag SDO_DOWNLOAD_EXP_R2_CNF_T;

/* 2 commands uses this packet definition: ECAT_LOCAL_SDO_UPLOAD_EXP_REQ and ECAT_SDO_UPLOAD_EXP_REQ */
__TLR_PACKED_PRE struct SDO_UPLOAD_EXP_R2_REQ_DATA_Ttag
{
  /* address of SDO server, set to 0 for ECAT_LOCAL_SDO_UPLOAD_EXP_REQ service */
  TLR_UINT32              ulServerAddress;
  /* index of SDO */
  TLR_UINT32              ulIndex;
  /* subindex of SDO */
  TLR_UINT32              ulSubIndex;
  /* access flags for SDO (complete access, evt. priority) */
  TLR_UINT32              ulAccessFlags;
  /* max length of SDO that can be put into the confirmation packet */
  TLR_UINT32              ulMaxSDOLength;
} __TLR_PACKED_POST;

typedef struct SDO_UPLOAD_EXP_R2_REQ_DATA_Ttag SDO_UPLOAD_EXP_R2_REQ_DATA_T;


struct SDO_UPLOAD_EXP_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  SDO_UPLOAD_EXP_R2_REQ_DATA_T tData;
};

typedef struct SDO_UPLOAD_EXP_R2_REQ_Ttag SDO_UPLOAD_EXP_R2_REQ_T;


#define SDO_UPLOAD_EXP_DATA_SIZE_R2 (1556)

__TLR_PACKED_PRE struct SDO_UPLOAD_EXP_R2_CNF_DATA_Ttag
{
  TLR_UINT8 abData[SDO_UPLOAD_EXP_DATA_SIZE_R2];
} __TLR_PACKED_POST;

typedef struct SDO_UPLOAD_EXP_R2_CNF_DATA_Ttag SDO_UPLOAD_EXP_R2_CNF_DATA_T;


struct SDO_UPLOAD_EXP_R2_CNF_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  SDO_UPLOAD_EXP_R2_CNF_DATA_T tData;
};

typedef struct SDO_UPLOAD_EXP_R2_CNF_Ttag SDO_UPLOAD_EXP_R2_CNF_T;


/**************************************************************/
/* the following packets have the old depreciated definitions */
/**************************************************************/

#define SDO_MAX_EXPEDITED_DATA_SIZE (512)
/* SDO download/upload request variant for non-pointer-based access */

__TLR_PACKED_PRE struct SDO_DOWNLOAD_EXP_REQ_Ttag
{
  /* destination of the packet (task message queue reference) */
  TLR_UINT32  ulDest;
  /* source of the packet (task message queue reference) */
  TLR_UINT32  ulSrc;
  /* destination reference (internal use for message routing) */
  TLR_UINT32  ulDestId;
  /* source reference (internal use for message routing) */
  TLR_UINT32  ulSrcId;
  /* length of packet data (starting from the end of the header) */
  TLR_UINT32  ulLen;
  /* identification reference (internal use by the sender) */
  TLR_UINT32  ulId;
  /* operation status code (error code, initialize with 0) */
  TLR_UINT32  ulSta;
  /* operation command code */
  TLR_UINT32  ulCmd;
  /* extension count (nonzero in multi-packet transfers) */
  TLR_UINT32  ulExt;
  /* router reference (internal use for message routing) */
  TLR_UINT32  ulRout;

  /* address of SDO server : parameter to be set */
  TLR_UINT32              ulServerAddress;
  /* index of SDO : parameter to be set  */
  TLR_UINT32              ulIndex;
  /* subindex of SDO : parameter to be set  */
  TLR_UINT32              ulSubIndex;
  /* access flags for SDO like priority, complete access etc */
  TLR_UINT32              ulAccessFlags;
  /* length of SDO : parameter to be set  */
  TLR_UINT32              ulSDOLength;
  /* data of SDO download */
  TLR_UINT8               abData[SDO_MAX_EXPEDITED_DATA_SIZE];
} __TLR_PACKED_POST;

typedef struct SDO_DOWNLOAD_EXP_REQ_Ttag SDO_DOWNLOAD_EXP_REQ_T;
typedef TLR_PACKET_HEADER_T SDO_DOWNLOAD_EXP_CNF_T;

#define SDO_DOWNLOAD_EXP_DATA_REQ_SIZE (sizeof(SDO_DOWNLOAD_EXP_REQ_T)-sizeof(TLR_PACKET_HEADER_T)-SDO_MAX_EXPEDITED_DATA_SIZE)
#define SDO_DOWNLOAD_EXP_DATA_CNF_SIZE (0)

__TLR_PACKED_PRE struct SDO_UPLOAD_EXP_REQ_Ttag
{
  /* destination of the packet (task message queue reference) */
  TLR_UINT32  ulDest;
  /* source of the packet (task message queue reference) */
  TLR_UINT32  ulSrc;
  /* destination reference (internal use for message routing) */
  TLR_UINT32  ulDestId;
  /* source reference (internal use for message routing) */
  TLR_UINT32  ulSrcId;
  /* length of packet data (starting from the end of the header) */
  TLR_UINT32  ulLen;
  /* identification reference (internal use by the sender) */
  TLR_UINT32  ulId;
  /* operation status code (error code, initialize with 0) */
  TLR_UINT32  ulSta;
  /* operation command code */
  TLR_UINT32  ulCmd;
  /* extension count (nonzero in multi-packet transfers) */
  TLR_UINT32  ulExt;
  /* router reference (internal use for message routing) */
  TLR_UINT32  ulRout;

  /* address of SDO server : parameter to be set  */
  TLR_UINT32              ulServerAddress;
  /* index of SDO : parameter to be set  */
  TLR_UINT32              ulIndex;
  /* subindex of SDO : parameter to be set  */
  TLR_UINT32              ulSubIndex;
  /* access flags for SDO like priority, complete access etc : parameter to be set  */
  TLR_UINT32              ulAccessFlags;
  /* max length of SDO that can be put into the confirmation packet */
  TLR_UINT32              ulMaxSDOLength;
} __TLR_PACKED_POST;

#define SDO_UPLOAD_EXP_DATA_REQ_SIZE (sizeof(SDO_UPLOAD_EXP_REQ_T)-sizeof(TLR_PACKET_HEADER_T))

__TLR_PACKED_PRE struct SDO_UPLOAD_EXP_CNF_Ttag
{
  /* destination of the packet (task message queue reference) */
  TLR_UINT32  ulDest;
  /* source of the packet (task message queue reference) */
  TLR_UINT32  ulSrc;
  /* destination reference (internal use for message routing) */
  TLR_UINT32  ulDestId;
  /* source reference (internal use for message routing) */
  TLR_UINT32  ulSrcId;
  /* length of packet data (starting from the end of the header) */
  TLR_UINT32  ulLen;
  /* identification reference (internal use by the sender) */
  TLR_UINT32  ulId;
  /* operation status code (error code, initialize with 0) */
  TLR_UINT32  ulSta;
  /* operation command code */
  TLR_UINT32  ulCmd;
  /* extension count (nonzero in multi-packet transfers) */
  TLR_UINT32  ulExt;
  /* router reference (internal use for message routing) */
  TLR_UINT32  ulRout;

  TLR_UINT8               abData[SDO_MAX_EXPEDITED_DATA_SIZE];
} __TLR_PACKED_POST;

typedef struct SDO_UPLOAD_EXP_REQ_Ttag SDO_UPLOAD_EXP_REQ_T;
typedef struct SDO_UPLOAD_EXP_CNF_Ttag SDO_UPLOAD_EXP_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(SDO_PUBLIC)
#endif

#endif
